<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Company extends Model 
{

    protected $table = 'company';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function products()
    {
        return $this->belongsToMany('Product', 'company_region_product', 'company_id', 'product_id')->withPivot('region_id')->join('region', 'region_id', '=', 'region.id');
    }

    public function regions()
    {
        return $this->belongsToMany('Region', 'company_region_product', 'company_id', 'region_id')->withPivot('product_id')->join('product', 'product_id', '=', 'product.id');
    }

    public function vacancies()
    {
        return $this->hasMany('Vacancy');
    }

    public function news()
    {
        return $this->hasMany('News');
    }

    public function offers()
    {
        return $this->hasMany('Offer');
    }

}