<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Product extends Model 
{

    protected $table = 'product';
    public $timestamps = true;

    public function category()
    {
        return $this->belongsTo('Category');
    }

    public function companies()
    {
        return $this->belongsToMany('Company', 'company_region_product', 'product_id', 'company_id')->withPivot('region_id')->join('region', 'region_id', '=', 'region.id');;
    }

    public function regions()
    {
        return $this->belongsToMany('Region', 'company_region_product', 'product_id', 'region_id')->withPivot('company_id')->join('company', 'company_id', '=', 'company.id');;
    }

}