<?php

namespace App;

class Region extends Eloquent {

	protected $table = 'region';
	public $timestamps = true;

	public function companies()
	{
		return $this->belongsToMany('Company', 'company_region_product', 'region_id', 'company_id')->withPivot('product_id')->join('product', 'product_id', '=', 'product.id');
	}

	public function products()
	{
		return $this->belongsToMany('Product', 'company_region_product', 'region_id', 'product_id')->withPivot('company_id')->join('company', 'company_id', '=', 'company.id');;
	}

}