<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Pedido extends Eloquent {

	protected $table = 'pedidos';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function estado()
	{
		return $this->hasOne('EstadosPago', 'estado_id');
	}

	public function envio()
	{
		return $this->hasOne('Envio');
	}

	public function viaje()
	{
		return $this->hasOne('\Viaje');
	}

}