<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Posicion extends Eloquent {

	protected $table = 'posicion';
	public $timestamps = false;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function viaje()
	{
		return $this->belongsTo('Viaje');
	}

	public function envio()
	{
		return $this->hasMany('Envio');
	}

	public function localidad()
	{
		return $this->hasOne('Localidad');
	}

}