<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Viaje extends Eloquent {

	protected $table = 'viajes';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function posiciones()
	{
		return $this->hasMany('Posicion');
	}

	public function transportista()
	{
		return $this->belongsTo('Usuario', 'transportista_id');
	}

	public function metodoCobro()
	{
		return $this->hasOne('Metodo', 'cobro_id');
	}

}