<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Viaje extends Model 
{

    protected $table = 'viajes';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function posiciones()
    {
        return $this->hasMany('Posicion');
    }

    public function transportista()
    {
        return $this->belongsTo('Usuario', 'transportista_id');
    }

    public function metodoCobro()
    {
        return $this->hasOne('Metodo', 'cobro_id');
    }

}