<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('usuarios', function(Blueprint $table) {
			$table->foreign('configuracion_id')->references('id')->on('configuraciones')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('viajes', function(Blueprint $table) {
			$table->foreign('cobro_id')->references('id')->on('metodos')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('viajes', function(Blueprint $table) {
			$table->foreign('transportista_id')->references('id')->on('usuarios')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('posicion', function(Blueprint $table) {
			$table->foreign('localidad_id')->references('id')->on('localidades')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('posicion', function(Blueprint $table) {
			$table->foreign('viaje_id')->references('id')->on('viajes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('localidades', function(Blueprint $table) {
			$table->foreign('provincia_id')->references('id')->on('provincias')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('paquetes', function(Blueprint $table) {
			$table->foreign('envio_id')->references('id')->on('envios')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('alertas', function(Blueprint $table) {
			$table->foreign('usuario_id')->references('id')->on('usuarios')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('alertas', function(Blueprint $table) {
			$table->foreign('tipo_alertas_id')->references('id')->on('tipo_alertas')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('mensajes', function(Blueprint $table) {
			$table->foreign('remite_id')->references('id')->on('usuarios')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('mensajes', function(Blueprint $table) {
			$table->foreign('destinatario_id')->references('id')->on('usuarios')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('puntos', function(Blueprint $table) {
			$table->foreign('localidad_id')->references('id')->on('localidades')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('puntos', function(Blueprint $table) {
			$table->foreign('usuario_id')->references('id')->on('usuarios')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('envios', function(Blueprint $table) {
			$table->foreign('estado_id')->references('id')->on('estados')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('envios', function(Blueprint $table) {
			$table->foreign('usuario_id')->references('id')->on('usuarios')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('envios', function(Blueprint $table) {
			$table->foreign('punto_recogida_id')->references('id')->on('puntos')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('envios', function(Blueprint $table) {
			$table->foreign('punto_entrega_id')->references('id')->on('puntos')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('envios', function(Blueprint $table) {
			$table->foreign('cobertura_id')->references('id')->on('coberturas')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('envios', function(Blueprint $table) {
			$table->foreign('destinatario_id')->references('id')->on('mensajes')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('envios', function(Blueprint $table) {
			$table->foreign('pago_id')->references('id')->on('metodos')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('provincias', function(Blueprint $table) {
			$table->foreign('pais_id')->references('id')->on('paises')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('pedidos', function(Blueprint $table) {
			$table->foreign('estado_pago_id')->references('id')->on('estados_pago')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('pedidos', function(Blueprint $table) {
			$table->foreign('envio_id')->references('id')->on('envios')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('pedidos', function(Blueprint $table) {
			$table->foreign('viaje_id')->references('id')->on('viajes')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('saldos', function(Blueprint $table) {
			$table->foreign('usuario_id')->references('id')->on('usuarios')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('puntuaciones', function(Blueprint $table) {
			$table->foreign('rol_id')->references('id')->on('roles')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('puntuaciones', function(Blueprint $table) {
			$table->foreign('usuario_id')->references('id')->on('usuarios')
						->onDelete('set null')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('usuarios', function(Blueprint $table) {
			$table->dropForeign('usuarios_configuracion_id_foreign');
		});
		Schema::table('viajes', function(Blueprint $table) {
			$table->dropForeign('viajes_cobro_id_foreign');
		});
		Schema::table('viajes', function(Blueprint $table) {
			$table->dropForeign('viajes_transportista_id_foreign');
		});
		Schema::table('posicion', function(Blueprint $table) {
			$table->dropForeign('posicion_localidad_id_foreign');
		});
		Schema::table('posicion', function(Blueprint $table) {
			$table->dropForeign('posicion_viaje_id_foreign');
		});
		Schema::table('localidades', function(Blueprint $table) {
			$table->dropForeign('localidades_provincia_id_foreign');
		});
		Schema::table('paquetes', function(Blueprint $table) {
			$table->dropForeign('paquetes_envio_id_foreign');
		});
		Schema::table('alertas', function(Blueprint $table) {
			$table->dropForeign('alertas_usuario_id_foreign');
		});
		Schema::table('alertas', function(Blueprint $table) {
			$table->dropForeign('alertas_tipo_alertas_id_foreign');
		});
		Schema::table('mensajes', function(Blueprint $table) {
			$table->dropForeign('mensajes_remite_id_foreign');
		});
		Schema::table('mensajes', function(Blueprint $table) {
			$table->dropForeign('mensajes_destinatario_id_foreign');
		});
		Schema::table('puntos', function(Blueprint $table) {
			$table->dropForeign('puntos_localidad_id_foreign');
		});
		Schema::table('puntos', function(Blueprint $table) {
			$table->dropForeign('puntos_usuario_id_foreign');
		});
		Schema::table('envios', function(Blueprint $table) {
			$table->dropForeign('envios_estado_id_foreign');
		});
		Schema::table('envios', function(Blueprint $table) {
			$table->dropForeign('envios_usuario_id_foreign');
		});
		Schema::table('envios', function(Blueprint $table) {
			$table->dropForeign('envios_punto_recogida_id_foreign');
		});
		Schema::table('envios', function(Blueprint $table) {
			$table->dropForeign('envios_punto_entrega_id_foreign');
		});
		Schema::table('envios', function(Blueprint $table) {
			$table->dropForeign('envios_cobertura_id_foreign');
		});
		Schema::table('envios', function(Blueprint $table) {
			$table->dropForeign('envios_destinatario_id_foreign');
		});
		Schema::table('envios', function(Blueprint $table) {
			$table->dropForeign('envios_pago_id_foreign');
		});
		Schema::table('provincias', function(Blueprint $table) {
			$table->dropForeign('provincias_pais_id_foreign');
		});
		Schema::table('pedidos', function(Blueprint $table) {
			$table->dropForeign('pedidos_estado_pago_id_foreign');
		});
		Schema::table('pedidos', function(Blueprint $table) {
			$table->dropForeign('pedidos_envio_id_foreign');
		});
		Schema::table('pedidos', function(Blueprint $table) {
			$table->dropForeign('pedidos_viaje_id_foreign');
		});
		Schema::table('saldos', function(Blueprint $table) {
			$table->dropForeign('saldos_usuario_id_foreign');
		});
		Schema::table('puntuaciones', function(Blueprint $table) {
			$table->dropForeign('puntuaciones_rol_id_foreign');
		});
		Schema::table('puntuaciones', function(Blueprint $table) {
			$table->dropForeign('puntuaciones_usuario_id_foreign');
		});
	}
}