<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('personnels', function(Blueprint $table) {
			$table->foreign('services_id')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('personnels', function(Blueprint $table) {
			$table->foreign('equipes_id')->references('id')->on('equipes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('personnels', function(Blueprint $table) {
			$table->foreign('qualites_id')->references('id')->on('qualites')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('equipes', function(Blueprint $table) {
			$table->foreign('nom_equipe_id')->references('id')->on('nom_equipes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('personnels', function(Blueprint $table) {
			$table->dropForeign('personnels_services_id_foreign');
		});
		Schema::table('personnels', function(Blueprint $table) {
			$table->dropForeign('personnels_equipes_id_foreign');
		});
		Schema::table('personnels', function(Blueprint $table) {
			$table->dropForeign('personnels_qualites_id_foreign');
		});
		Schema::table('equipes', function(Blueprint $table) {
			$table->dropForeign('equipes_nom_equipe_id_foreign');
		});
	}
}