<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateResourcesTable extends Migration {

	public function up()
	{
		Schema::create('resources', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('resource_type');
			$table->longText('body')->nullable();
			$table->text('image')->nullable();
			$table->text('video')->nullable();
			$table->string('status', 15)->default('active');
		});
	}

	public function down()
	{
		Schema::drop('resources');
	}
}