<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTeamsTable extends Migration {

	public function up()
	{
		Schema::create('teams', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('type')->nullable();
			$table->string('name');
			$table->string('role');
			$table->longText('details')->nullable();
			$table->string('image')->nullable();
			$table->string('facebook')->nullable();
			$table->string('twitter')->nullable();
			$table->string('email')->nullable();
			$table->string('status', 30)->default('active');
		});
	}

	public function down()
	{
		Schema::drop('teams');
	}
}