<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMenuItemsTable extends Migration {

	public function up()
	{
		Schema::create('menu_items', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('area_id')->unsigned();
			$table->float('price', 8,2);
			$table->string('name', 255);
			$table->integer('ttc');
			$table->tinyInteger('active');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('menu_items');
	}
}