<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOpdProceduresTable extends Migration {

	public function up()
	{
		Schema::create('opd_procedures', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name')->unique();
			$table->decimal('price');
			$table->enum('cost_type', array('cash', 'insurence'));
			$table->enum('staus', array('available', 'unavailable'));
		});
	}

	public function down()
	{
		Schema::drop('opd_procedures');
	}
}