<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVitalsTable extends Migration {

	public function up()
	{
		Schema::create('vitals', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('patient_id')->unsigned();
			$table->bigInteger('clinician_id')->unsigned();
			$table->smallInteger('pulse')->unsigned()->nullable();
			$table->double('temperature', 3,1)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('vitals');
	}
}