<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Bed extends Eloquent {

	protected $table = 'beds';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'ward_id', 'gender_type', 'status');
	protected $visible = array('name', 'ward_id', 'gender_type', 'status');

	public function ward()
	{
		return $this->belongsTo('App\Ward');
	}

}