<?php

namespace App;

class Prescription extends Eloquent {

	protected $table = 'prescriptions';
	public $timestamps = true;
	protected $fillable = array('patient_id', 'clinician_id', 'medicine_id', 'dose', 'route', 'status', 'prescription_status', 'prescription_type', 'opd_ipd_id');
	protected $visible = array('patient_id', 'clinician_id', 'medicine_id', 'dose', 'route', 'status', 'prescription_status', 'prescription_type', 'opd_ipd_id');

	public function medicines()
	{
		return $this->hasMany('App\Medicine', 'id', 'medicine_id');
	}

}