<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBedsTable extends Migration {

	public function up()
	{
		Schema::create('beds', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name')->unique();
			$table->bigInteger('ward_id')->unsigned();
			$table->enum('gender_type', array('male', 'female', 'both'));
			$table->enum('status', array('available', 'unavailable'));
		});
	}

	public function down()
	{
		Schema::drop('beds');
	}
}