<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePatientBillsTable extends Migration {

	public function up()
	{
		Schema::create('patient_bills', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('patient_id')->unsigned();
			$table->enum('bill_type', array('debit', 'credit'));
			$table->decimal('amount');
			$table->timestamp('date_time');
		});
	}

	public function down()
	{
		Schema::drop('patient_bills');
	}
}