<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSurgeryTypesTable extends Migration {

	public function up()
	{
		Schema::create('surgery_types', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name')->unique();
			$table->enum('staus', array('available', 'unavailable'));
			$table->decimal('price');
			$table->enum('cost_type', array('insurace', 'cash'));
		});
	}

	public function down()
	{
		Schema::drop('surgery_types');
	}
}