<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Admission extends Eloquent {

	protected $table = 'admissions';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('patient_id', 'clinician_id', 'ward_id', 'bed_id', 'status');
	protected $visible = array('patient_id', 'clinician_id', 'ward_id', 'bed_id', 'status');

	public function fluids()
	{
		return $this->hasMany('App\Fluid');
	}

}