<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Patient extends Eloquent {

	protected $table = 'patients';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'gender', 'patient_type', 'insurance_type', 'insurance_number', 'date_of_birth', 'is_pregnant', 'phone_number', 'address', 'contact_person', 'contact_person_phone_number');
	protected $visible = array('name', 'gender', 'patient_type', 'insurance_type', 'insurance_number', 'date_of_birth', 'is_pregnant', 'phone_number', 'address', 'contact_person', 'contact_person_phone_number');

	public function bills()
	{
		return $this->hasMany('App\PatientBills');
	}

	public function prescriptions()
	{
		return $this->hasMany('App\Prescription');
	}

	public function surgeries()
	{
		return $this->hasMany('App\Surgery');
	}

	public function transfusions()
	{
		return $this->hasMany('App\Transfusion');
	}

	public function opdEntries()
	{
		return $this->hasMany('App\OPDEntry');
	}

	public function fluids()
	{
		return $this->hasMany('App\Fluid');
	}

	public function ipdEntries()
	{
		return $this->hasMany('App\IPDEntry');
	}

}