<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class SurgeryType extends Eloquent {

	protected $table = 'surgery_types';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'staus', 'price', 'cost_type');
	protected $visible = array('name', 'staus', 'price', 'cost_type');

	public function surgeries()
	{
		return $this->hasMany('App\Surgery');
	}

}