<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Ward extends Eloquent {

	protected $table = 'wards';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('gender_type', 'department_id', 'name');
	protected $visible = array('gender_type', 'department_id', 'name');

	public function department()
	{
		return $this->belongsTo('App\Department');
	}

	public function beds()
	{
		return $this->hasMany('App\Bed');
	}

}