<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLabRequestsTable extends Migration {

	public function up()
	{
		Schema::create('lab_requests', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('lab_test_id')->unsigned();
			$table->enum('status', array('pending', 'received', 'finalised'));
		});
	}

	public function down()
	{
		Schema::drop('lab_requests');
	}
}