<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMedicinesTable extends Migration {

	public function up()
	{
		Schema::create('medicines', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name')->unique();
			$table->decimal('price');
			$table->enum('cost_type', array('cash', 'insurence'));
			$table->integer('quantity');
			$table->enum('status', array('available', 'unavailable'));
			$table->string('formulation');
		});
	}

	public function down()
	{
		Schema::drop('medicines');
	}
}