<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSurgeriesTable extends Migration {

	public function up()
	{
		Schema::create('surgeries', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('patient_id')->unsigned();
			$table->bigInteger('clinician_id')->unsigned();
			$table->bigInteger('surgery_type_id')->unsigned();
			$table->mediumText('notes');
			$table->enum('status', array('completed', 'ongoing', 'pending'));
			$table->date('date');
			$table->timestamp('start_time')->nullable();
			$table->timestamp('end_time')->nullable();
			$table->string('pre_op_diagnosis')->nullable();
			$table->string('post_op_diagnosis');
		});
	}

	public function down()
	{
		Schema::drop('surgeries');
	}
}