<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateArticlesTable extends Migration {

	public function up()
	{
		Schema::create('articles', function(Blueprint $table) {
			$table->increments('id');
			$table->string('slug', 255)->unique()->nullable();
			$table->integer('category_id')->unsigned()->nullable()->index();
			$table->string('title', 255)->nullable()->index();
			$table->text('content')->nullable();
			$table->string('image_name', 255)->nullable();
			$table->tinyInteger('featured')->default('0');
			$table->tinyInteger('flag')->index()->default('0');
			$table->integer('count_views')->default('0');
			$table->integer('count_shares')->default('0');
			$table->string('meta_title', 150)->nullable();
			$table->string('meta_description', 255)->nullable();
			$table->string('meta_image', 255)->nullable();
			$table->integer('created_by')->unsigned()->index();
			$table->integer('updated_by')->unsigned()->nullable()->index();
			$table->integer('deleted_by')->unsigned()->nullable()->index();
			$table->datetime('published_at')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('articles');
	}
}