<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('categories', function(Blueprint $table) {
			$table->increments('id');
			$table->string('slug', 255)->unique()->nullable();
			$table->string('image_name', 255)->nullable();
			$table->string('name', 50);
			$table->string('short_description')->nullable();
			$table->text('long_description')->nullable();
			$table->tinyInteger('active')->index()->default('1');
			$table->smallInteger('position')->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('categories');
	}
}