<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductSpecificationsTable extends Migration {

	public function up()
	{
		Schema::create('product_specifications', function(Blueprint $table) {
			$table->integer('product_id')->unsigned()->index();
			$table->integer('brand_id')->unsigned()->index();
			$table->string('product_measures', 255)->nullable();
			$table->decimal('package_weight', 8,3)->default('0');
			$table->decimal('package_width')->default('0');
			$table->decimal('package_length')->default('0');
			$table->decimal('package_height')->default('0');
			$table->text('package_content')->nullable();
			$table->integer('warranty_id')->unsigned()->index();
		});
	}

	public function down()
	{
		Schema::drop('product_specifications');
	}
}