<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTagsTable extends Migration {

	public function up()
	{
		Schema::create('tags', function(Blueprint $table) {
			$table->increments('id');
			$table->string('slug', 255)->unique()->nullable();
			$table->string('name', 100)->index();
			$table->text('description')->nullable();
			$table->tinyInteger('active')->index()->default('1');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('tags');
	}
}