<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Article extends Model 
{

    protected $table = 'articles';
    public $timestamps = true;
    protected $fillable = array('user_id', 'category_id', 'title', 'content', 'mulai', 'selesai');

    public function user()
    {
        return $this->belongsTo('User');
    }

    public function headline()
    {
        return $this->hasOne('Headline');
    }

    public function image()
    {
        return $this->hasMany('Image');
    }

    public function category()
    {
        return $this->belongsTo('Category');
    }

}