<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->bigInteger('id')->primary();
			$table->string('name', 255)->nullable();
			$table->string('email', 255);
			$table->char('mobile', 10);
			$table->enum('type', array('super_admin', 'admin', 'store', 'client'));
			$table->string('slogan_ar', 255);
			$table->string('slogan_en', 255);
			$table->timestamp('email_verified_at');
			$table->string('password', 255);
			$table->string('remember_token', 100);
			$table->tinyInteger('is_active');
			$table->tinyInteger('is_verified');
			$table->char('otp', 4);
			$table->datetime('otp_expires_at');
			$table->string('photo', 255);
			$table->date('birth_date');
			$table->string('location', 255);
			$table->string('lat', 255);
			$table->string('lng', 255);
			$table->string('device_token', 255);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}