<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotificationsTable extends Migration {

	public function up()
	{
		Schema::create('notifications', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title');
			$table->text('body');
			$table->integer('item_id');
			$table->tinyInteger('is_read');
			$table->bigInteger('send_from');
			$table->bigInteger('send_to');
			$table->enum('notification_type', array('message', 'reservation'));
			$table->datetime('scheduled_date');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('notifications');
	}
}