<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStoreServicesTable extends Migration {

	public function up()
	{
		Schema::create('store_services', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('store_id')->nullable();
			$table->bigInteger('service_id')->nullable();
			$table->tinyInteger('is_active');
			$table->double('price');
			$table->integer('session_time');
			$table->bigInteger('category_id');
			$table->bigInteger('sub_category_id');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('store_services');
	}
}