<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTimeCashesTable extends Migration {

	public function up()
	{
		Schema::create('time_cashes', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('client_id');
			$table->string('store_id');
			$table->integer('employee_id');
			$table->integer('service_id');
			$table->date('date');
			$table->time('session_from');
			$table->time('session_to');
			$table->integer('length_service');
			$table->timestamp('end_at');
		});
	}

	public function down()
	{
		Schema::drop('time_cashes');
	}
}