<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrphanSiblingTable extends Migration {

	public function up()
	{
		Schema::create('orphan_sibling', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('orphan_id')->unsigned()->nullable();
			$table->string('first_name', 50)->nullable();
			$table->string('last_name', 50)->nullable();
			$table->date('date_of_birth')->nullable();
			$table->string('relationship', 50)->nullable();
			$table->text('details_en')->nullable();
			$table->text('details_ar')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('orphan_sibling');
	}
}