<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrphanTable extends Migration {

	public function up()
	{
		Schema::create('orphan', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('house_id')->nullable();
			$table->string('name_en')->nullable();
			$table->string('name_ar')->nullable();
			$table->string('first_name', 50)->nullable();
			$table->string('last_name', 50)->nullable();
			$table->date('date_of_birth')->nullable();
			$table->text('place_of_birth')->nullable();
			$table->string('orphan_status', 50)->nullable();
			$table->string('parent_status', 50)->nullable();
			$table->text('special_need')->nullable();
			$table->text('activity_program')->nullable();
			$table->text('challenge')->nullable();
			$table->text('financial_material_need')->nullable();
			$table->string('type', 50)->nullable();
			$table->text('caretaker_details_en')->nullable();
			$table->text('caretaker_details_ar')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('orphan');
	}
}