<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Client extends Eloquent {

	protected $table = 'client';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'first_name', 'last_name', 'mobile_number');

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

}