<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Orphan extends Eloquent {

	protected $table = 'orphan';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('house_id', 'name_en', 'name_ar', 'first_name', 'last_name', 'date_of_birth', 'place_of_birth', 'orphan_status', 'parent_status', 'special_need', 'activity_program', 'challenge', 'financial_material_need', 'type', 'caretaker_details_en', 'caretaker_details_ar');

	public function house()
	{
		return $this->belongsTo('House', 'house_id');
	}

}