<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDonationTable extends Migration {

	public function up()
	{
		Schema::create('donation', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->double('amount')->nullable();
			$table->datetime('donation_date')->nullable();
			$table->boolean('is_specific')->nullable();
			$table->string('payment_method', 50)->nullable();
			$table->string('payment_reference', 100)->nullable();
			$table->string('donation_type', 20)->nullable();
			$table->integer('user_id')->nullable();
			$table->integer('orphan_id')->nullable();
			$table->integer('house_id')->nullable();
			$table->integer('special_need_id')->nullable();
			$table->integer('donation_category_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('donation');
	}
}