<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Post extends Eloquent {

	protected $table = 'posts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('title', 'description', 'post_type_id', 'created_by');

	public function type()
	{
		return $this->hasOne('App\Models\LookupPostType', 'post_type_id');
	}

	public function values()
	{
		return $this->hasMany('App\Models\PostAttributeValue', 'post_id');
	}

	public function user()
	{
		return $this->belongsTo('App\Models\User', 'created_by');
	}

	public function categories()
	{
		return $this->belongsToMany('App\Models\Category', 'posts_categories_join');
	}

	public function attributes()
	{
		return $this->belongsToMany('App\Models\Attribute', 'posts_type_attributes_join', 'attribute_id');
	}

	public function tags()
	{
		return $this->belongsToMany('App\Models\Tag', 'posts_tags_join');
	}

}