<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Tag extends Eloquent {

	protected $table = 'tags';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'display', 'description');

	public function posts()
	{
		return $this->belongsToMany('App\Models\Post', 'posts_tags_join');
	}

}