<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('email');
			$table->string('username')->nullable();
			$table->string('password');
			$table->string('first_name')->nullable();
			$table->string('last_name')->nullable();
			$table->softDeletes();
			$table->timestamps();
			$table->integer('job_id')->unsigned()->nullable();
			$table->integer('slots')->unsigned()->nullable();
			$table->integer('team_ids')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}