<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContactsTable extends Migration {

	public function up()
	{
		Schema::create('contacts', function(Blueprint $table) {
			$table->increments('contactid');
			$table->integer('memberid')->unsigned();
			$table->integer('userid');
			$table->string('firstname', 256);
			$table->string('lastname', 256);
			$table->string('email', 256);
			$table->string('phone', 256);
			$table->string('ext', 256);
			$table->string('celphone', 256);
			$table->tinyInteger('primary')->default('1');
			$table->string('photo', 256);
		});
	}

	public function down()
	{
		Schema::drop('contacts');
	}
}