<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMemberTable extends Migration {

	public function up()
	{
		Schema::create('member', function(Blueprint $table) {
			$table->increments('memberid');
			$table->string('name', 256);
			$table->string('address', 256);
			$table->string('country', 256);
			$table->string('state', 256);
			$table->string('telephone', 256);
			$table->string('fax', 256);
			$table->string('website', 256);
			$table->enum('services', array('TransferPricing', 'Accounting', 'Taxconsulting', 'Audit', 'Offshoreservices', 'Legal'));
			$table->string('photo', 256);
		});
	}

	public function down()
	{
		Schema::drop('member');
	}
}