<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Appreciation extends Eloquent {

	protected $table = 'appreciations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('teacher_id', 'student_id', 'subject_id', 'subject', 'message', 'images');
	protected $visible = array('teacher_id', 'student_id', 'subject_id', 'subject', 'message', 'images');

	public function teacher()
	{
		return $this->belongsToMany('App\Teacher');
	}

	public function student()
	{
		return $this->belongsToMany('App\Student');
	}

}