<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Group extends Eloquent {

	protected $table = 'groups';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('school_id', 'name', 'description', 'active');
	protected $visible = array('school_id', 'name');

	public function group()
	{
		return $this->hasMany('App\Student');
	}

	public function school()
	{
		return $this->belongsTo('App\School');
	}

	public function groupSubjectTeacher()
	{
		return $this->hasMany('App\GroupSubjectTeacher');
	}

}