<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Parent extends Eloquent {

	protected $table = 'parents';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('father_name', 'mother_name', 'email', 'password', 'contact_no', 'type', 'active');
	protected $visible = array('father_name', 'mother_name', 'email');

	public function student()
	{
		return $this->belongsToMany('App\Student');
	}

}