<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class GroupSubjectTeacher extends Model 
{

    protected $table = 'group_subject_teacher';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('teacher_id', 'group_id', 'subject_id', 'session');
    protected $visible = array('group_id');

    public function group()
    {
        return $this->belongsToMany('App\Group', 'group_id');
    }

    public function subject()
    {
        return $this->belongsToMany('App\Subject', 'subject_id');
    }

    public function teacher()
    {
        return $this->belongsToMany('App\Teacher', 'teacher_id');
    }

}