<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('parent_id')->default('11');
			$table->integer('project_id')->default('11');
			$table->integer('relation_id')->unsigned()->default('11');
			$table->string('number');
			$table->enum('type', array('sales', 'production', 'purchase', 'assembly'));
			$table->text('description');
			$table->string('contact', 255);
			$table->date('creation_date');
			$table->date('promised_date');
			$table->date('desired_date');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}